/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.NumberComparator;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.cmdhelpers.FspVioEtherConfig;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.rep.RCimWrapper;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import com.ibm.hsc.rep.v50.R50Partition;
import com.ibm.hsc.rep.v50.R50VirtualEthernet;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class PIVirtualEthernetMACAddressUtils {
    private static final int MAC_MULTICAST = 65536;
    private static final int MAC_PRIVATE = 131072;
    private OmCecMgr m_cecMgr;
    private String m_prefix;

    public PIVirtualEthernetMACAddressUtils(OmCecMgr omCecMgr) throws PIHscServerException {
        this.m_cecMgr = omCecMgr;
        try {
            this.m_prefix = this.m_cecMgr.getSaveArea().getVirtEthernetMacAddrPrefix();
        }
        catch (Throwable throwable) {
            System.out.println("Caught exception in PIVirtualEthernetMACAddressUtils constructor: trying to get VEMaccAddr prefix from SaveArea.");
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECResourceClassLogInfo);
            Trace.trace("apcshscT", "<~ PIVirtualEthernetMACAddressUtils()");
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("03FE", throwable);
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            try {
                Trace.trace("aplphscT", "<- PIVirtualEthernetMACAddressUtils");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * Loose catch block
     */
    void setVirtualEthernetMACAddressPrefix(CIMObjectPath cIMObjectPath, Vector vector) throws PIHscServerException {
        block27: {
            int n;
            Object object;
            String string;
            block26: {
                CIMProperty cIMProperty = (CIMProperty)vector.get(0);
                CIMValue cIMValue = cIMProperty.getValue();
                string = (String)cIMValue.getValue();
                Trace.trace("apcshscT", "-> setVirtualEthernetMACAddressPrefix(" + string + ")");
                this.checkMACAddressPrefix(string);
                string = string.toUpperCase();
                if (!this.m_cecMgr.isHypervisorRunning()) {
                    Trace.trace("apcshscT", "<~ setVirtualEthernetMACAddressPrefix()");
                    throw new PIHscServerException("0223");
                }
                try {
                    object = (UnsignedInt8)this.m_cecMgr.getObject().getProperty(R50ComputerSystem.Index_State);
                    if (object == null || object.intValue() != 17) {
                        throw new PIHscServerException("0227");
                    }
                }
                catch (RException rException) {
                    rException.printStackTrace();
                    Trace.trace("apcshscF", "Unable to get PHYP state");
                    HSCLogUtils.serverLog(rException, HSCLogUtils._CECResourceClassLogInfo);
                    throw new PIHscServerException("03FE", rException);
                }
                object = null;
                n = 64;
                object = new FspLockHelper(this.m_cecMgr.getFspLockMgr(), n);
                ((FspLockHelper)object).addNvramLock(this.m_cecMgr.getObjectId());
                ((FspLockHelper)object).lock();
                this.m_cecMgr.getSaveArea().setVirtEthernetMacAddrPrefix(string);
                Object var10_9 = null;
                try {
                    if (object != null) {
                        System.out.println("leaving setVirtualEthernetMACAddressPrefix: Releasing the FSP LOCK");
                        ((FspLockHelper)object).unlock();
                    }
                    Trace.trace("aplphscT", "<- setVirtualEthernetMACAddressPrefix");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                break block26;
                {
                    catch (Throwable throwable) {
                        Trace.trace("apcshscF", "Unable to set the VirtualEthernetMACAddressPrefix property.");
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._CECResourceClassLogInfo);
                        Trace.trace("apcshscT", "<~ setVirtualEthernetMACAddressPrefix()");
                        if (!(throwable instanceof PIHscServerException)) {
                            throw new PIHscServerException("03FE", throwable);
                        }
                        throw (PIHscServerException)throwable;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    try {
                        if (object != null) {
                            System.out.println("leaving setVirtualEthernetMACAddressPrefix: Releasing the FSP LOCK");
                            ((FspLockHelper)object).unlock();
                        }
                        Trace.trace("aplphscT", "<- setVirtualEthernetMACAddressPrefix");
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                    }
                    throw throwable;
                }
            }
            this.m_prefix = string;
            try {
                this.m_cecMgr.getObject().setProperty(R50ComputerSystem.Index_VirtualEthernetMACAddressPrefix, (Object)this.m_prefix);
            }
            catch (RException rException) {
                Trace.trace("apcshscF", "Unable to set the VirtualEthernetMACAddressPrefix property.");
                HSCLogUtils.serverLog(rException, HSCLogUtils._CECResourceClassLogInfo);
                Trace.trace("apcshscT", "<~ setVirtualEthernetMACAddressPrefix()");
                throw new PIHscServerException("03FE", rException);
            }
            object = null;
            object = new FspLockHelper(this.m_cecMgr.getFspLockMgr(), n);
            ((FspLockHelper)object).addCecLock(this.m_cecMgr.getObjectId());
            ((FspLockHelper)object).lock();
            this.updateVirtualEthernetMACAddresses(cIMObjectPath);
            Object var13_17 = null;
            try {
                if (object != null) {
                    System.out.println("leaving setVirtualEthernetMACAddressPrefix: Releasing the FSP LOCK");
                    ((FspLockHelper)object).unlock();
                }
                Trace.trace("aplphscT", "<- setVirtualEthernetMACAddressPrefix");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            break block27;
            {
                catch (Throwable throwable) {
                    Trace.trace("apcshscF", "Unable to update the VirtualEthernetMACAddressPrefix property.");
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._CECResourceClassLogInfo);
                    Trace.trace("apcshscT", "<~ setVirtualEthernetMACAddressPrefix()");
                    if (!(throwable instanceof PIHscServerException)) {
                        throw new PIHscServerException("03FE", throwable);
                    }
                    throw (PIHscServerException)throwable;
                }
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                try {
                    if (object != null) {
                        System.out.println("leaving setVirtualEthernetMACAddressPrefix: Releasing the FSP LOCK");
                        ((FspLockHelper)object).unlock();
                    }
                    Trace.trace("aplphscT", "<- setVirtualEthernetMACAddressPrefix");
                }
                catch (Throwable throwable3) {
                    throwable3.printStackTrace();
                }
                throw throwable;
            }
        }
        Trace.trace("apcshscT", "<- setVirtualEthernetMACAddressPrefix()");
    }

    private void checkMACAddressPrefix(String string) throws PIHscServerException {
        int n;
        try {
            n = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.trace("apcshscF", "MAC address prefix is not a valid hexstring");
            throw new PIHscServerException("03FC", numberFormatException);
        }
        if (string.length() != 6) {
            Trace.trace("apcshscF", "MAC address prefix does not have length 6, it has length: " + string.length());
            throw new PIHscServerException("03FC");
        }
        if ((n & 0x10000) != 0) {
            Trace.trace("apcshscF", "MAC address prefix must not have multicast bit turned on.");
            throw new PIHscServerException("03FD");
        }
    }

    private void updateVirtualEthernetMACAddresses(CIMObjectPath cIMObjectPath) throws PIHscServerException {
        RObjectId rObjectId = null;
        try {
            rObjectId = RCimWrapper.getObjectId(cIMObjectPath);
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            HSCLogUtils.serverLog(cIMException, HSCLogUtils._CECResourceClassLogInfo);
            throw new PIHscServerException("03FE", cIMException);
        }
        try {
            RObject rObject = rObjectId.getObject();
            Vector vector = rObject.associatorsByLink(0);
            if (vector != null && vector.size() > 0) {
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    RObject rObject2 = (RObject)iterator.next();
                    String string = (String)rObject2.getProperty(R50Partition.Index_Name);
                    UnsignedInt16 unsignedInt16 = new UnsignedInt16(string.substring(0, string.indexOf("*")));
                    Vector vector2 = rObject2.associatorsByLink(130);
                    if (vector2 == null || vector2.size() <= 0) continue;
                    Iterator iterator2 = vector2.iterator();
                    while (iterator2.hasNext()) {
                        RObject rObject3 = (RObject)iterator2.next();
                        UnsignedInt16 unsignedInt162 = new UnsignedInt16((String)rObject3.getProperty(R50VirtualEthernet.Index_Name));
                        FspVioEtherConfig fspVioEtherConfig = this.getCurrentConfiguration(rObject3);
                        this.updateVirtualEthernetMACAddress(unsignedInt16, unsignedInt162, fspVioEtherConfig);
                    }
                }
            }
        }
        catch (RException rException) {
            Trace.trace("apcshscF", "Unable to update MAC address prefix: " + rException.getMessage());
            rException.printStackTrace();
            HSCLogUtils.serverLog(rException, HSCLogUtils._CECResourceClassLogInfo);
            throw new PIHscServerException("03FE", rException);
        }
    }

    private FspVioEtherConfig getCurrentConfiguration(RObject rObject) throws RException {
        Object object;
        UnsignedInt8 unsignedInt8;
        UnsignedInt8 unsignedInt82 = (UnsignedInt8)rObject.getProperty(R50VirtualEthernet.Index_IsIEEE);
        UnsignedInt8 unsignedInt83 = null;
        Boolean bl = (Boolean)rObject.getProperty(R50VirtualEthernet.Index_Required);
        unsignedInt83 = bl != null && bl != false ? new UnsignedInt8(2) : new UnsignedInt8(1);
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)rObject.getProperty(R50VirtualEthernet.Index_PVlanID);
        UnsignedInt16[] unsignedInt16Array = null;
        Vector vector = rObject.associatorsByLink(281);
        if (vector != null && vector.size() > 0) {
            unsignedInt8 = new TreeSet(new NumberComparator());
            object = vector.iterator();
            int n = 0;
            while (object.hasNext()) {
                RObject rObject2 = (RObject)object.next();
                String string = (String)rObject2.getProperty("Name");
                UnsignedInt16 unsignedInt162 = new UnsignedInt16(string);
                if (!unsignedInt162.equals((Object)unsignedInt16)) {
                    unsignedInt8.add(unsignedInt162);
                }
                ++n;
            }
            unsignedInt16Array = unsignedInt8.toArray(new UnsignedInt16[unsignedInt8.size()]);
        } else {
            unsignedInt16Array = new UnsignedInt16[]{};
        }
        unsignedInt8 = null;
        object = rObject.associatorNamesByLink(282);
        unsignedInt8 = object != null && ((Vector)object).size() > 0 ? new UnsignedInt8(1) : new UnsignedInt8(0);
        return new FspVioEtherConfig(unsignedInt82, unsignedInt83, unsignedInt16, unsignedInt8, null, unsignedInt16Array);
    }

    public void updateVirtualEthernetMACAddress(UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, FspVioEtherConfig fspVioEtherConfig) {
        String string = this.getMACAddress(unsignedInt16, unsignedInt162);
        fspVioEtherConfig.setMACAddress(string);
        System.out.println("Setting virtual Ethernet MAC address: " + fspVioEtherConfig.getMACAddress());
        try {
            this.m_cecMgr.getCmdHelper().setVirtualEthernetSlotConfiguration(unsignedInt16, unsignedInt162, fspVioEtherConfig);
        }
        catch (Exception exception) {
            Trace.trace("apcshscF", "Exception: Unable to update MAC address for partition: " + unsignedInt16 + ", slot: " + unsignedInt162);
            exception.printStackTrace();
            HSCLogUtils.serverLog(exception, HSCLogUtils._CECResourceClassLogInfo);
        }
    }

    public String getMACAddress(UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162) {
        String string;
        String string2;
        int n;
        String string3 = ByteUtilities.toHexString((Number)unsignedInt16, 4);
        int n2 = string3.length();
        if (n2 > 4) {
            string3 = string3.substring(n2 - 4);
        }
        if ((n = (string2 = ByteUtilities.toHexString((Number)unsignedInt162, 3)).length()) > 3) {
            string2 = string2.substring(n - 3);
        }
        if ((string = this.m_prefix).length() < 5) {
            string = string + "00000";
        }
        string = this.m_prefix.substring(0, 5);
        return string + string3 + string2;
    }

    public static String getDefaultMACAddressPrefix(String string) {
        Trace.trace("apcshscT", "-> getDefaultMACAddressPrefix(" + string + ")");
        if (string == null || string.length() < 3) {
            string = "000" + string;
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = PIVirtualEthernetMACAddressUtils.getThreeBytes(byArray);
        int n = (byArray2[0] << 16 | 0x20000) & 0xFFFEFFFF;
        byArray2[0] = (byte)(n >> 16);
        String string2 = ByteUtilities.toHexString(byArray2);
        Trace.trace("apcshscT", "<- getDefaultMACAddressPrefix() = \"" + string2 + "\"");
        return string2;
    }

    private static byte[] getThreeBytes(byte[] byArray) {
        byte[] byArray2 = new byte[3];
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray3 = messageDigest.digest(byArray);
            System.arraycopy(byArray3, 0, byArray2, 0, 3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (byArray.length < 3) {
                Random random = new Random();
                random.nextBytes(byArray2);
            }
            byte[] byArray4 = new byte[3];
            for (int i = 0; i < 3; ++i) {
                byte by = 1;
                for (int j = 7; j > 0; --j) {
                    int n = i;
                    byArray4[n] = (byte)(byArray4[n] | (byArray[byArray.length - 4 + i] & by) << j);
                    by = (byte)(by << 1);
                }
            }
            byArray2[0] = byArray4[1];
            byArray2[1] = byArray4[2];
            byArray2[2] = byArray4[0];
        }
        return byArray2;
    }
}

